local assets =
{
    Asset("ANIM", "anim/roncatdoll.zip"),
    Asset("ANIM", "anim/roncatdoll_anim.zip"),
	Asset("ATLAS", "images/inventoryimages/roncatdoll.xml"),
    Asset("ANIM", "anim/roncatdoll_katia.zip"),
	Asset("ATLAS", "images/inventoryimages/roncatdoll_katia.xml"),
}
local prefabs = 
{
    "beefalowool",
    "coontail",
    "nightmarefuel",
	"doydoyfeather",
	"fabric",
}
local function onattacked(inst)
	if inst.components.health.currenthealth > 0 then
		inst.AnimState:PlayAnimation((inst:HasTag("aquatic") and "hit_water") or "hit")
		inst.AnimState:PushAnimation((inst:HasTag("aquatic") and "idle_water") or "idle")
	else
		inst.AnimState:PlayAnimation((inst:HasTag("aquatic") and "death_water") or "death")
	end
end
local function onhealthdelta(inst)
	if inst.components.fueled then
		inst.components.fueled.currentfuel = inst.components.health.currenthealth
		inst.components.fueled:DoDelta(0)
	end
end
local function ondeath(inst)
	inst.AnimState:PlayAnimation((inst:HasTag("aquatic") and "death_water") or "death")
	if inst.components.lootdropper == nil then
        inst:AddComponent("lootdropper")
    end
	inst:DropLootFn()
end
local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()

    MakeInventoryPhysics(inst)
	
	if IsDLCEnabled(CAPY_DLC) then
		MakeInventoryFloatable(inst, "idle_water", "idle")
	end

    inst.AnimState:SetBank("roncatdoll")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("roncattargettaker")
    inst:AddTag("character")
    inst:AddTag("companion")
    inst:AddTag("notraptrigger")
	
	-- I made this too big
	inst.Transform:SetScale(0.6,0.6,0.6)

    inst:AddComponent("inspectable")

    inst:AddComponent("fuel")
    inst.components.fuel.fuelvalue = TUNING.LARGE_FUEL

    MakeLargeBurnableCharacter(inst, nil, Vector3(0, 0, 0))

    inst:AddComponent("inventoryitem")
	
	inst:AddComponent("health")
	inst.components.health:SetMaxHealth(1000)
	inst.components.health.canmurder = false
	inst.components.health.canheal = false
	
	--
	inst:AddComponent("fueled")
	inst.components.fueled.fueltype = "USAGE"
	inst.components.fueled:InitializeFuelLevel(1000)
	
    inst:AddComponent("combat")
	
	inst:ListenForEvent("attacked", onattacked)
	inst:ListenForEvent("healthdelta", onhealthdelta)
	inst:ListenForEvent("death", ondeath)
	
	if IsDLCEnabled(REIGN_OF_GIANTS) or IsDLCEnabled(CAPY_DLC) then
		inst:AddComponent("playerlightningtarget")
		inst.components.playerlightningtarget:SetHitChance(0.75)
	end

    return inst
end

local function ron()
	local inst = fn()
    inst.AnimState:SetBuild("roncatdoll")
	
	inst.components.inventoryitem.atlasname = "images/inventoryimages/roncatdoll.xml"
	
	inst.DropLootFn = function()
		if IsDLCEnabled(CAPY_DLC) and SaveGameIndex:IsModeShipwrecked() then
			inst.components.lootdropper:SpawnLootPrefab("fabric")
			inst.components.lootdropper:SpawnLootPrefab("fabric")
			inst.components.lootdropper:SpawnLootPrefab("doydoyfeather")
			inst.components.lootdropper:SpawnLootPrefab("doydoyfeather")
		elseif IsDLCEnabled(REIGN_OF_GIANTS) then
			inst.components.lootdropper:SpawnLootPrefab("coontail")
			inst.components.lootdropper:SpawnLootPrefab("beefalowool")
			inst.components.lootdropper:SpawnLootPrefab("beefalowool")
		else
			inst.components.lootdropper:SpawnLootPrefab("beefalowool")
			inst.components.lootdropper:SpawnLootPrefab("beefalowool")
			inst.components.lootdropper:SpawnLootPrefab("beefalowool")
		end
	end
	
	return inst
end
local function katia()
	local inst = fn()
    inst.AnimState:SetBuild("roncatdoll_katia")
	
	inst.components.inventoryitem.atlasname = "images/inventoryimages/roncatdoll_katia.xml"
    inst.components.inspectable.nameoverride = "roncatdoll"
	
	inst.DropLootFn = function()
		inst.components.lootdropper:SpawnLootPrefab("nightmarefuel")
		inst.components.lootdropper:SpawnLootPrefab("nightmarefuel")
		inst.components.lootdropper:SpawnLootPrefab("nightmarefuel")
	end
	
	return inst
end

return Prefab("common/inventory/roncatdoll", ron, assets, prefabs),
	Prefab("common/inventory/roncatdoll_katia", katia, assets, prefabs)